---
heading: "Usage"
---

1) Include the stylesheet
---

E.g. add this to the host document's `<head>`:

    <link rel="stylesheet" href="http://example.com/cleanslate.css">

If you are distributing a JavaScript widget, you may add it programatically:

    document.getElementsByTagName('head')[0]
        .appendChild(document.createElement('link'))
        .setAttribute('href', 'http://example.com/cleanslate.css');

Alternatively, ["@import"](http://www.w3.org/TR/CSS2/cascade.html#at-import it) Cleanslate into an existing stylesheet or `<style>` element:

    <style>
        @import http://example.com/cleanslate.css
    </style>



2) Add the class <code>'cleanslate'</code> to the container html
---

The `cleanslate` element will have its styles reset:

    <body>
      <div class="blah">
          <!-- general content is not affected -->
          <div class="myContainer cleanslate">
              <!-- this content will be reset -->
          </div>
      </div>
    </body>


Or, add the class programatically:

    jQuery('.myContainer').addClass('cleanslate');


3) Use <code>!important</code> to your css rules
---

For all of your CSS rules that relate to a `cleanslate` element or its children, add the keyword `!important`:

    .myContainer a {
        color: orange !important;
    }
    .myContainer .someOtherThing {
        font-weight: bold !important;
    }


4) [optional] Set the default styles
---

Cleanslate automatically applies the following styles to any `cleanslate` element and its children:

    .cleanslate {
        font-family: "Times New Roman", Times, serif !important;
        font-size: medium !important;
        color: black !important;
        line-height: 1 !important;
        direction: ltr !important;
        text-align: left !important;
        font-style: normal !important;
        font-weight: normal !important;
        text-decoration: none !important;
    }

If you want to override these default styles, then simply add the new values to your own stylesheet. It's best to use a CSS selector that is specific to your content, instead of using `.cleanslate`, in case there are other `.cleanslate` elements on the page. For example:

    .myContainer {
        font-family: Verdana, Arial, sans-serif !important;
        color: #003 !important;
    }
